<?php 
include_once __DIR__.'/config.php'; 
include_once __DIR__.'/telegram.php';
include_once(__DIR__.'/vray.php');  

$telegram = new telegram(TOKEN, HOST, USERNAME, PASSWORD, DBNAME);
$time = time();

$server_id = isset($_GET['sid']) ? intval($_GET['sid']) : 0;
$days = isset($_GET['days']) ? intval($_GET['days']) : -30;
if($server_id == 0) die('no server id');

$response = getList($server_id);
if(is_null($response) or $response === false or !isset($response->obj)) {die('no response from server');}
$response = $response->obj; 

$count = 0;
foreach($response as $row) {
    $inbound_id = $row->id;
    $settings = json_decode($row->settings, true); 
    $clientStats = $row->clientStats ?? []; // اگر مقدار clientStats وجود نداشته باشد، آرایه خالی تنظیم می‌شود
    $clients = $settings['clients'] ?? []; // بررسی می‌کنیم که clients خالی نباشد

    if (count($clients) > 1) { // فقط اینباندهایی که چند کلاینت دارند
        foreach ($clients as $client) {
            $remark = $client['email']; // در V2Ray نام کلاینت معمولاً در email ذخیره می‌شود
            $expiryTime = isset($client['expiryTime']) ? intval($client['expiryTime'] / 1000) : 0;

            if ($expiryTime == 0 || $expiryTime < 0) {
                continue;
            }

            if (is_numeric($expiryTime) && $expiryTime < time() + ($days * 86400)) {
                $count++;
                remove_client($server_id, $inbound_id, $remark, 1);
            }
        }
    }
}
echo $count;